#ifndef __CBitmapImage__
#define __CBitmapImage__

#include "CBaseImage.hpp"
using Exponent::GUI::Graphics::CBaseImage;

//	===========================================================================

namespace Exponent
{
	namespace GUI
	{
		namespace Graphics
		{
			/**
			 * @class CBitmapImage CBitmapImage.hpp
			 * @brief Represents a system image. On windows this is a Bitmap format file and on OSX it is a PICT resource
			 * @note Mac version is currently inoperable due to the stupidity of the mac API's. Will be implemented ASAP
			 * @todo Imlement mac pict loading
			 *
			 * @date 30/09/2006
			 * @author Paul Chana
			 * @version 1.0.0 Initial version
			 *
			 * @note All contents of this source code are copyright 2005 Exp Digital Uk.\n
			 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy\n
			 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
			 * All content is the Intellectual property of Exp Digital Uk.\n
			 * Certain sections of this code may come from other sources. They are credited where applicable.\n
			 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
			 *
			 * $Id: CBitmapImage.hpp,v 1.2 2007/02/08 21:07:54 paul Exp $
			 */
			class CBitmapImage : public CBaseImage
			{
				/** @cond */
				EXPONENT_CLASS_DECLARATION;
				/** @endcond */

//	===========================================================================

			public:

//	===========================================================================
				
				/**
				 * Construction with a file name
				 * @param filename Name of the file to load
				 * @throws CException On load error
				 */
				CBitmapImage(const CSystemString &filename);

				/**
				 * Construction
				 */
				CBitmapImage();

				/**
				 * Destruction
				 */
				virtual ~CBitmapImage();

//	===========================================================================
				/**
				 * Get the format
				 * @retval EImageFormats The format of the image
				 */
				virtual EImageFormats getImageFormat() const { return e_bitmap; }

//	===========================================================================

				/**
				 * Load from a file
				 * @param filename The name of the file, expected to be a 32bpp TGA file 
				 * @retval bool True if loaded the image properly, false on error
				 */
				virtual bool loadFromFile(const CSystemString &filename);

//	===========================================================================

				/**
				 * Get a new bitmap image instance
				 * @param path The containing folder of the image
				 * @param filename the name of the file
				 * @retval CBitmapImage* The new instance or NULL on error
				 */
				static CBitmapImage *getNewInstance(const CSystemString &path, const CString &filename);
			};
		}
	}
}
#endif	// End of CBitmapImage.hpp